/*
 * Created on Aug 20, 2003
 *
 */
package Data;

import java.sql.*;

/**
 * @author student
 * This class is being used for getting and setting announcement data
 * 
 */
	public class AnnouncementData {
		String from;
		String body;
		String subject;
		Timestamp time;

	/**
	 * Constructor for AnnouncementData.java
	 */
	public AnnouncementData() {
	}

	/**
	 * Constructor for AnnouncementData.java with parameters
	 */
	public AnnouncementData(
		String from,
		String body,
		String subject,
		Timestamp time) {
		this.from = from;
		this.body = body;
		this.subject = subject;
		this.time = time;
	}

	/**
	 * This method is being used to get the Firstname and the lastname of the person 
	 *  who  posted the announcement.
	 * @param none
	 * @return String The person who posted the announcement.
	 */
	public String getFrom() {
		return from;
	}
	/**
	 * This method is being used  set the Firstname and the lastname of the person 
	 *  who  posted the announcement.
	 * @param from the person who posted the announcement. 
	 * @return void
	 */
	public void setFrom(String from) {
		this.from = from;
	}

	/**
	 * This method is being used to get the body of the announcement.
	 * @param none
	 * @return String body of the announcement.
	 */
	public String getBody() {
		return body;
	}
	/**
	 * This method is being used to set the body of the announcement
	 * @param body Body of the announcement
	 * @return void
	 */
	public void setBody(String body) {
		this.body = body;
	}
	/**
	 * This method is being used to get the subject of the announcement.
	 * @return String the subject of the announcement.
	 */
	public String getSubject() {
		return subject;
	}
	/**
	 * This method is being used to set the subject of the announcement.
	 * @param String the subject of the announcement.
	 * @return void
	*/
	public void setSubject(String subject) {
		this.subject = subject;
	}
	/**
	 * This method is being used to get the time the announcement was posted.
	 * @return Timestamp time the announcement was posted.
	 */
	public Timestamp getTime() {
		return time;
	}
	/**
	 * This method is being used to set the time the announcement was posted.
	 * @param  Timestamp time the announcement was posted.
	 * @return void
	 */
	public void setTime(Timestamp time) {
		this.time = time;
	}
}